//**********************************************************************************************
//* WebMail Library
//* ---------------
//* A collection of internet e-mail protocol (POP, SMTP, IMAP) 
//* encapsulation classes for Ultimate++
//* 

#include "WebMail.h"


String EMail::Get(String in, String s)
{


	String item = Null;
	int	pos = in.Find(s), i = 0;
	if(pos >= 0) {
		pos += s.GetLength();
		item = in.Mid(pos);
		// Find if there are any whitespaces (space or tab).
		i = 0;
		for(const char *c = item.Begin() + 1; c < item.Last() - 1; c++) {
			i++;
			if(*c == '\n') {
				if(*(c - 1) == '\r' && (*(c + 1) != ' ' && *(c + 1) != '\t')) {
					i--;
					item.Trim(i);
					item << '\0';
					break;
				}
			}
		}
	}
	return item;
}

String EMail::GetNext(String& in, String s)
{
	String next = '\0';
	int pos = in.Find(s), i = 0;
	if(pos >= 0) {
		pos += s.GetLength();
		next = in.Mid(pos, in.GetLength() - pos);
		if((i = next.Find("\r\n.\r\n")) >= 0)
			next.Trim(i);
	}
	return next;
}
String EMail::GetPrev(String& in, String s)
{
	String prev = '\0';
	return prev;
}


String EMail::Body()
{
	String header, body, item;
	int pos = 0, i = 0, j = 0;
	// Check content-type, if mail is consisted of any MIME.
	// Currently, only text/plain, is supported.
	String type = Type();
	if(type.Find("text/plain") >= 0) 
		body = GetNext(mail, "\r\n\r\n");
	else if(type.Find("text/html") >= 0) {
		body = "Content Type: text/html is not implemented yet";
	}
	else if(type.Find("multipart/mixed") >= 0) {
		body = "Content Type: multipart/mixed is not implemented yet";
	}
	if(type.Find("multipart/alternative") >= 0) {
		body = "Content Type: multipart/alternative is not implemented yet";
	}
	return body;
}

String EMail::Header()
{
	String header = Null;
	int pos = mail.Find("\r\n\r\n");
	if(pos >= 0)
		header.Cat(mail, pos); 
	return header;
}
